/* functions to partially emulate some ncurses calls with escape sequences.
chris@toxicbreakfast.com 2009 */

#include <stdarg.h>

#define COLS 80
#define LINES 28

#define A_DIM 0x00001000
#define A_BOLD 0x00002000
#define A_ALTCHARSET 0x00010000
#define A_COLOR	0x03fe0000
#define	COLOR_PAIR(n) ((((unsigned long int)n) << 17) & A_COLOR)
#define	PAIR_NUMBER(n)	((((unsigned long int)n) & A_COLOR) >> 17)

#define addstr(s) puts(s)
#define clear() printf("\x1b[2J")
#define clrtoeol() printf("\x1b[K")
#define refresh() ;

typedef long int attr_t;

extern const attr_t attrglobal;

int attr_get(attr_t *attrs, short *pair, void *opts);
int attrset(attr_t attrs);
int move(int y, int x);
int mvaddch(int y, int x, unsigned char ch);
int mvprintw(int y, int x, char *fmt,...);
int printw(char *fmt,...);
