#include <stdio.h> /* include added by chris 18/10/2009 to make macros
                      in wiicurses.h work without generating compiler warning*/

void full_draw(screen_object o, bool in_place)
{
  attr_t old;
  short dummy;
  attr_t new;

  attr_get(&old,&dummy,0);

  /*Set the proper color.*/
  new = COLOR_PAIR(o.color);

  /*Special case to get a grey robot*/
  if (o.character == '#') new |= A_DIM;
  if (o.character <= '\32') new |= A_ALTCHARSET;
  if (o.bold) new |= A_BOLD;

  attrset(new);
  if (in_place)
    {
      printw("%c",o.character);
    }  else {
      mvprintw(o.y,o.x,"%c",o.character);
      move(o.y,o.x);
    }

  attrset(old);
}

void draw(screen_object o) { full_draw(o,FALSE); }

void draw_in_place(screen_object o) { full_draw(o,TRUE); }

void message(char* message)
{
  move(3,0); /*moved lower on screen by chris 20/10/2009*/
  clrtoeol();
  mvprintw(3,2,"%.*s",COLS-2,message);
  move(robot.y,robot.x);
  refresh();
}
