#include <stdio.h>
#include <string.h>
#include "wiicurses.h"

const attr_t attrglobal=0x000e1000;

int attr_get(attr_t *attrs, short *pair, void *opts)
{
	*attrs=attrglobal;
	*pair=PAIR_NUMBER(attrglobal);
	return 0;
}

int attrset(attr_t attrs)
{
	char output[20]="\x1b[";
	char fmt[5];
	short colour;
	printf("\x1b[s");
	colour=PAIR_NUMBER(attrs)+30;
	sprintf(fmt,"%2d;",colour);
	strcat(output,fmt);
	if(attrs&A_BOLD)
		strcat(output,"1m");
	else
		strcat(output,"0m");
	if(attrs&A_ALTCHARSET); //don't know
	puts(output);
    printf("\x1b[u");
	return 0;
}

int move(int y, int x)
{
	return printf("\x1b[%02d;%02dH",y,x);
}

int mvaddch(int y, int x, unsigned char ch)
{
	return printf("\x1b[%02d;%02dH%c",y,x,ch);
}

int mvprintw(int y, int x, char *fmt,...)
{
	int ret;
	va_list argptr;
	va_start(argptr,fmt);
	printf("\x1b[%02d;%02dH",y,x);
	ret=vprintf(fmt,argptr);
	va_end(argptr);
	return ret;
}

int printw(char *fmt,...)
{
	int ret;
	va_list argptr;
	va_start(argptr,fmt);
	ret=vprintf(fmt,argptr);
	va_end(argptr);
	return ret;
}
